<?php
/**
 * BuddyPress - Members Home
 *
 * @since   1.0.0
 * @version 3.0.0
 */

$profile_layout = woffice_get_theming_option('profile_layout');
$profile_layout = (isset($_GET['profile_layout'])) ? $_GET['profile_layout'] : $profile_layout;
?>

	<?php bp_nouveau_member_hook( 'before', 'home_content' ); ?>

	<div class="bp-wrap row woffice-profile--<?php echo esc_attr($profile_layout); ?>" data-template="woffice">

        <div class="<?php echo esc_attr(($profile_layout === 'vertical') ? 'col-md-4' : 'col-md-12'); ?>" data-template="woffice">
            <div id="woffice-bp-sidebar" data-template="woffice">
                <div id="item-header" role="complementary" data-bp-item-id="<?php echo esc_attr( bp_displayed_user_id() ); ?>" data-bp-item-component="members" class="users-header single-headers">
                  <?php $bp_disable_avatar = bp_get_option( 'bp-disable-cover-image-uploads', false );
                        if($bp_disable_avatar){?>
                    <div class="cover_container_not">
                        <div class="inner_container_not">
                          <?php bp_nouveau_member_header_template_part(); ?>
                        </div>
                    </div>
                    <?php } else{ ?>
                    <?php bp_nouveau_member_header_template_part(); ?>
                    <?php }  ?>
                </div><!-- #item-header -->
                
                <?php if($profile_layout == 'vertical') {?>
                    <!-- Iten social -->
                    <div class="users-single-social">
                        <?php woffice_member_social_extend(); ?>
                    </div>
                    <!-- /Iten social -->
                <?php } ?>

                <?php if($profile_layout == 'vertical') {?>
                    <!-- Iten single-subnav -->
                    <div class="users-single-subnav">
                        <nav class="<?php bp_nouveau_single_item_subnav_classes(); ?>" id="subnav" role="navigation">
                            <ul class="subnav">

                                <?php bp_get_template_part( 'members/single/parts/item-subnav' ); ?>

                            </ul>
                        </nav><!-- .item-list-tabs#subnav -->
                    </div>
                <?php } ?>

                <!-- Iten item-subnav -->
                <div class="users-single-itemnav">
                    <?php bp_get_template_part( 'members/single/parts/item-nav' ); ?>
                </div>
                
            </div>
        </div>
        
        <div class="<?php echo esc_attr(($profile_layout === 'vertical') ? 'col-md-8' : 'col-md-12'); ?>" data-template="woffice">

            <div id="item-body" class="item-body">

                <?php if($profile_layout == 'horizontal') {?>
                     <!-- Iten single-subnav -->
                    <div class="users-single-subnav">
                        <nav class="<?php bp_nouveau_single_item_subnav_classes(); ?>" id="subnav" role="navigation">
                            <ul class="subnav">

                                <?php bp_get_template_part( 'members/single/parts/item-subnav' ); ?>

                            </ul>
                        </nav><!-- .item-list-tabs#subnav -->
                    </div>
                <?php } ?>

		        <?php bp_nouveau_member_template_part(); ?>

            </div><!-- #item-body -->
            
        </div>

	</div><!-- // .bp-wrap -->

	<?php bp_nouveau_member_hook( 'after', 'home_content' ); ?>
