<?php
    $theme_skin = woffice_get_settings_option('theme_skin');

    //IF Fixed we add a nav class
    $header_fixed = woffice_get_settings_option('header_fixed');
    $extra_navbar_class = ( $header_fixed == "yep" ) ? 'has_fixed_navbar' :'';

    $nav_opened_state = woffice_get_navigation_state();
    $sidebar_state = woffice_get_sidebar_state();
    $sidebar_show_class = ($sidebar_state != 'show') ? 'sidebar-hidden' : '';

	$is_blank_template = woffice_is_current_page_using_blank_template();
	$blank_template_class = ($is_blank_template) ? 'is-blank-template' : '';

    $hentry_class = apply_filters('woffice_hentry_class', 'hentry');
     // We add a class if the menu is closed by default
     $navigation_hidden_class = woffice_get_navigation_class();
?>
		<div id="page-wrapper" <?php echo (!$nav_opened_state) ? 'class="menu-is-closed"':''; ?>>

			<?php
            /*
             * The header part is removed on the blank template
             */
			if(!$is_blank_template): ?>

                <!-- STARTING THE MAIN NAVIGATION (left side) -->
                <nav id="navigation" class="<?php echo esc_attr($navigation_hidden_class); ?> mobile-hidden">
                    <?php
                    /*
                     * Display the menu
                     */
                    if ( !is_user_logged_in() && has_nav_menu('public')) :
                            $settings_menu_public = array('theme_location' => 'public','menu_class' => 'main-menu', 'menu' => '','container' => '','menu_id' => 'main-menu');
                            wp_nav_menu( $settings_menu_public );
                    else :
                        if ( has_nav_menu('primary') ) :
                            $settings_menu_on = array('theme_location' => 'primary','menu_class' => 'main-menu', 'menu' => '','container' => '','menu_id' => 'main-menu');
                            wp_nav_menu( $settings_menu_on );
                        else :
                            wp_page_menu(array('menu_id' => 'main-menu', 'menu_class'  => 'main-menu', 'show_home' => true));
                        endif;
                    endif; ?>
                </nav>
                <!-- END MAIN NAVIGATION -->


                <!-- START HEADER -->
                <?php // CHECK FROM OPTIONS
                $header_user = woffice_get_theming_option('header_user');
                $header_user_class = (woffice_validate_bool_option($header_user)) ? 'has-user': 'user-hidden';
                ?>
                <header id="main-header" class="<?php echo esc_attr($navigation_hidden_class) . ' ' . esc_attr($header_user_class ).' '. esc_attr($sidebar_show_class); ?>">

                    <nav id="navbar" class="<?php echo esc_attr($extra_navbar_class ); ?>">
                        <div id="nav-left">
                            <!-- NAVIGATION TOGGLE -->
                            <?php $nav_trigger_icon = (!$nav_opened_state) ? 'fa-bars' : 'fa-arrow-left' ;?>
                            <a href="javascript:void(0)" id="nav-trigger"><i class="fa <?php echo esc_attr($nav_trigger_icon) ?>"></i></a>


                            <?php // CHECK IF LOGO NEEDS TO BE SHOW
                            $header_logo_hide = woffice_get_theming_option('header_logo_hide');
                            if (woffice_validate_bool_option($header_logo_hide) == false) { ?>
                                <!-- START LOGO -->
                                <div id="nav-logo">

                                    <?php
                                    /**
                                    * The url of the logo in the header. By default, returns the home url
                                    *
                                    * @param string $url
                                    */
                                    $logo_link = apply_filters('woffice_logo_link_to', home_url( '/' ) );
                                    ?>

                                    <a href="<?php echo esc_url( $logo_link ); ?>">
                                        <?php
                                        $header_logo = woffice_get_theming_option('header_logo');
                                        // IF THERE IS A LOGO :
                                        if(!empty($header_logo)) :
                                            echo'<img src="'. esc_url($header_logo["url"]) .'" alt="Logo Image">';
                                        else:
                                            echo'<img src="'. get_template_directory_uri() .'/images/logo.png" alt="Logo Image">';
                                        endif; ?>
                                    </a>
                                </div>
                            <?php } ?>

                            <!-- USER INFORMATIONS -->
                            <?php
                            // CHECK FROM OPTIONS
                            $header_user = woffice_get_theming_option('header_user');
                            if (is_user_logged_in()) :
                                if (woffice_validate_bool_option($header_user)) : ?>
                                    <div id="nav-user" class="clearfix <?php echo (function_exists('bp_is_active')) ? 'bp_is_active' : ''; ?>">
                                        <a href="javascript:void(0);" id="user-thumb">
                                            <?php
                                            $name_to_display = woffice_get_name_to_display();
                                            echo __('Hi', 'woffice') .' <b class="font-weight-bold">'. $name_to_display .'</b>';
                                            ?>
                                            <?php // GET CURRENT USER ID
                                            $user_ID = get_current_user_id();
                                            echo get_avatar($user_ID);
                                            ?>
                                        </a>
                                        <?php if(function_exists('bp_is_active')) : ?>
                                            <a href="javascript:void(0)" id="user-close">
                                                <i class="fa fa-arrow-circle-right"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                <?php else: ?>
                                    <div id="nav-user" class="clearfix <?php echo (function_exists('bp_is_active')) ? 'bp_is_active' : ''; ?>">
                                        <a href="<?php echo wp_logout_url() ?>" id="user-login"><i class="fa fa-sign-out-alt"></i></a>
                                    </div>
                                <?php endif; ?>
                            <?php else : ?>
                                <div id="nav-user" class="clearfix <?php echo (function_exists('bp_is_active')) ? 'bp_is_active' : ''; ?>">
                                    <?php // SHOW LOGIN BUTTON
                                    $header_login = woffice_get_theming_option('header_login');
                                    if (!empty($header_login) && woffice_validate_bool_option($header_login)) {
                                        echo '<a href="'.wp_login_url().'" id="user-login"><i class="fa fa-sign-in-alt"></i></a>';
                                    } ?>
                                </div>
                            <?php endif; ?>
                        </div>

                        <!-- EXTRA BUTTONS ABOVE THE SIDBAR -->
                        <div id="nav-buttons">

                            <?php // FETCHING SIDEBAR INFO
                            if($sidebar_state == 'show' || $sidebar_state == 'hide') :  ?>
                                <!-- SIDEBAR TOGGLE -->
                                <a href="javascript:void(0)" id="nav-sidebar-trigger"><i class="fa fa-arrow-right"></i></a>
                            <?php endif; ?>

                            <?php // CHECK FROM OPTIONS
                            $header_search = woffice_get_theming_option('header_search');
                            /**
                             * Override the search feature
                             *
                             * @param string $header_search Value allowed: yep|nope
                             */
                            $header_search = apply_filters( 'woffice_header_search_enabled', $header_search);
                            if (woffice_validate_bool_option($header_search)) :  ?>
                                <!-- SEACRH FORM -->
                                <a href="javascript:void(0)" id="search-trigger"><i class="fa fa-search"></i></a>
                            <?php endif; ?>

                            <?php // WOOCOMMERCE CART TRIGGER
                            /**
                             * You can disable the minicart in the header form there
                             *
                             * @param bool
                             */
                            $minicart_header_enabled = apply_filters('woffice_show_minicart_in_header', true);

                            if (function_exists('is_woocommerce') && $minicart_header_enabled) : ?>
                                <?php //is cart empty ?
                                if ( WC()->cart->get_cart_contents_count() > 0 ) :
                                    $cart_url_topbar = "javascript:void(0)";
                                    $cart_classes = 'active cart-content';
                                else :
                                    $cart_url_topbar = get_permalink( wc_get_page_id( 'shop' ) );
                                    $cart_classes = "";
                                endif; ?>
                                <a href="<?php echo esc_url($cart_url_topbar); ?>"
                                   id="nav-cart-trigger"
                                   title="<?php _e( 'View your shopping cart', 'woffice' ); ?>"
                                   class="<?php echo esc_attr($cart_classes); ?>">
                                    <p class="stellar-mini-cart">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="23" viewBox="0 0 24 23" fill="none">
                                            <path d="M23.4624 4.64725C23.0079 4.06641 22.3005 3.71283 21.5682 3.71283H6.18748L5.70758 1.84386C5.42975 0.75796 4.47 0.000244141 3.35889 0.000244141H0.78276C0.353435 0.000244141 -0.00012207 0.353815 -0.00012207 0.783126C-0.00012207 1.21245 0.353449 1.56601 0.78276 1.56601H3.35889C3.73765 1.56601 4.06605 1.81864 4.16716 2.1974L7.24835 14.4717C7.52618 15.5576 8.48593 16.3153 9.59704 16.3153H19.6741C20.7854 16.3153 21.7703 15.5576 22.0228 14.4717L23.9169 6.69291C24.0936 5.98575 23.9421 5.22822 23.4622 4.64725H23.4624ZM22.3765 6.33938L20.4823 14.1181C20.3813 14.4969 20.053 14.7495 19.674 14.7495H9.597C9.21823 14.7495 8.88984 14.4969 8.78873 14.1181L6.59152 5.30389H21.5682C21.8208 5.30389 22.0732 5.43021 22.2248 5.63227C22.3764 5.83434 22.4522 6.08697 22.3764 6.33943L22.3765 6.33938Z" fill="#2D3342"/>
                                            <path d="M10.1274 17.3254C8.68775 17.3254 7.50092 18.5125 7.50092 19.9519C7.50092 21.3916 8.68793 22.5784 10.1274 22.5784C11.5671 22.5786 12.7541 21.3916 12.7541 19.9519C12.7541 18.5125 11.5671 17.3254 10.1274 17.3254ZM10.1274 20.9875C9.54658 20.9875 9.09189 20.533 9.09189 19.9519C9.09189 19.3711 9.5464 18.9164 10.1274 18.9164C10.7083 18.9164 11.1629 19.3709 11.1629 19.9519C11.1629 20.5076 10.683 20.9875 10.1274 20.9875Z" fill="#2D3342"/>
                                            <path d="M18.8153 17.3254C17.3757 17.3254 16.1888 18.5125 16.1888 19.9519C16.1888 21.3916 17.3759 22.5784 18.8153 22.5784C20.255 22.5784 21.4418 21.3914 21.4418 19.9519C21.4167 18.5125 20.255 17.3254 18.8153 17.3254ZM18.8153 20.9875C18.2345 20.9875 17.7798 20.533 17.7798 19.9519C17.7798 19.3711 18.2343 18.9164 18.8153 18.9164C19.3962 18.9164 19.8509 19.3709 19.8509 19.9519C19.8509 20.5076 19.371 20.9875 18.8153 20.9875Z" fill="#2D3342"/>
                                        </svg>
                                    </p>
                                    <span class="woocommerce-cart-count count"><bdi>
                                        <?php echo (sizeof( WC()->cart->get_cart()) > 0) ? WC()->cart->get_cart_contents_count() : ''; ?>
                                    </bdi></span>
                                </a>
                            <?php endif; ?>

                            <?php // Notification
                            if ( woffice_bp_is_active( 'notifications' ) && is_user_logged_in() ) : ?>
                                <a href="javascript:void(0)" id="nav-notification-trigger" title="<?php _e( 'View your notifications', 'woffice' ); ?>" class="<?php echo (bp_notifications_get_unread_notification_count( bp_loggedin_user_id() ) >= 1) ? "active" : "" ?>">
                                    <i class="fa fa-bell"></i>
                                </a>
                            <?php endif; ?>

                        </div>

                    </nav>

                    <!-- HIDDEN PARTS TRIGGERED BY JAVASCRIPT -->

                    <?php // CHECK FROM OPTIONS
                    $header_user = woffice_get_theming_option('header_user');
                    if (woffice_validate_bool_option($header_user) && function_exists('bp_is_active')) :
                        woffice_user_sidebar(true);
                    endif; ?>

                    <?php // WOOCOMMERCE CART CONTENT
                    if (function_exists('is_woocommerce')) { Woffice_WooCommerce::print_mini_cart(); } ?>

                    <?php // Notification content :
                    if ( woffice_bp_is_active( 'notifications' ) && is_user_logged_in() ) { woffice_notifications_menu(); } ?>

                    <?php // CHECK FROM OPTIONS
                    $header_search = woffice_get_theming_option('header_search');
                    if (woffice_validate_bool_option($header_search)) :  ?>
                        <!-- START SEARCH CONTAINER - WAITING FOR FIRING -->
                        <div id="main-search">
                            <div class="container">
                                <?php //GET THE SEARCH FORM
                                get_search_form(); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php
                    /*
                     * We render the alerts
                     */
                    woffice_alerts_render(); ?>

                </header>
                <!-- END NAVBAR -->


                <!-- STARTING THE SIDEBAR (right side) + content behind -->
                <?php
                // FETCHING SIDEBAR POSITION
                if ($sidebar_state == "show"){
                    $class = 'with-sidebar';
                } elseif ($sidebar_state == "hide") {
                    /*We need to check if the user has already clicked the button*/
                    if( !isset($_COOKIE['Woffice_sidebar_position']) || ! apply_filters( 'woffice_cookie_sidebar_enabled', false ) ) {
                        $class = 'sidebar-hidden';
                    }
                    else {
                        $class = '';
                    }
                } else {
                    $class = 'full-width';
                }
                ?>

                <!-- START CONTENT -->
                <section id="main-content" class="<?php echo esc_attr($class) .' '.esc_attr($navigation_hidden_class) .' '. esc_attr($hentry_class); ?>">

                    <?php // GET SIDEBAR
                    if($sidebar_state == 'show' || $sidebar_state == 'hide') :
                        get_sidebar();
                    endif; ?>

                    <!-- END SIDEBAR -->

    <?php else:

		echo '<section id="main-content" class="full-width navigation-hidden '. esc_attr($hentry_class) .'">';

	endif;
