<?php
/**
 * Class Woffice_WooCommerce
 *
 * Customizations to WooCommerce required by Woffice
 *
 * @since 2.4.5
 * @author Xtendify
 */
if( ! class_exists( 'Woffice_WooCommerce' ) ) {
    class Woffice_WooCommerce
    {

        /**
         * Woffice_WooCommerce constructor
         */
        public function __construct()
        {

            if (!function_exists('is_woocommerce'))
                return;

            // Single product change
            remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );

            add_filter( 'woocommerce_output_related_products_args', array($this,'woffice_related_products_args'));

            // Remove up sell display
            remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );

            add_action( 'woocommerce_after_single_product_summary', array($this, 'woffice_woocommerce_output_upsells'), 15 );

            add_filter( 'lostpassword_url',  array($this,'woffice_preserve_lostpassword_link'), 11, 0 );

            add_filter( 'woocommerce_add_to_cart_fragments', array($this, 'woffice_woocommerce_header_add_to_cart_fragment'));

            remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
            add_action( 'woocommerce_after_shop_loop', 'woocommerce_result_count', 5 );
        }

        /**
         * Related products custom arguments
         *
         * @return mixed
         */
        public function woffice_related_products_args() {
            $args['posts_per_page'] = 4; // 4 related products
            $args['columns'] = 4; // arranged in 2 columns
            return $args;
        }

        /**
         * Custom output for the upsells
         */
        public function woffice_woocommerce_output_upsells() {
            woocommerce_upsell_display( 4,4 ); // Display 3 products in rows of 3
        }

        /**
         * We preserve the default lost password page
         *
         * @return string
         */
        public function woffice_preserve_lostpassword_link() {
            return get_option('siteurl') .'/wp-login.php?action=lostpassword';
        }
    
        /**
         * Get mini cart contents
         */
        static function mini_cart_content()
        {
            if (sizeof(WC()->cart->get_cart()) > 0) { ?>
                <ul class="woffice-minicart-top-products">
                    <?php foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) :
                        $_product = $cart_item['data'];
                        // Only display if allowed
                        if (!apply_filters('woocommerce_widget_cart_item_visible', true, $cart_item,
                                $cart_item_key) || !$_product->exists() || $cart_item['quantity'] == 0) {
                            continue;
                        }
                        // Get price
                        $product_price = get_option('woocommerce_tax_display_cart') == 'excl' ? wc_get_price_excluding_tax($_product) : wc_get_price_including_tax($_product);
                        $product_price = apply_filters('woocommerce_cart_item_price_html', wc_price($product_price),
                            $cart_item, $cart_item_key);
                        ?>
                        <li class="woffice-mini-cart-product clearfix">
                        <span class="woffice-mini-cart-thumbnail">
                            <?php echo wp_kses_post($_product->get_image()); ?>
                        </span>
                            <span class="woffice-mini-cart-info">
                            <a class="woffice-mini-cart-title"
                               href="<?php echo get_permalink($cart_item['product_id']); ?>">
                                <h4><?php echo apply_filters('woocommerce_widget_cart_product_title',
                                        $_product->get_title(), $_product); ?></h4>
                            </a>
                                    <?php echo apply_filters('woocommerce_widget_cart_item_price',
                                        '<span class="woffice-mini-cart-price">' . __('Unit Price',
                                            'woffice') . ':' . $product_price . '</span>', $cart_item,
                                        $cart_item_key); ?>
                                <?php echo apply_filters('woocommerce_widget_cart_item_quantity',
                                    '<span class="woffice-mini-cart-quantity">' . __('Quantity',
                                        'woffice') . ':' . $cart_item['quantity'] . '</span>', $cart_item,
                                    $cart_item_key); ?>
                        </span>
                        </li>
                    <?php endforeach; ?>
                </ul><!-- end .tee-mini-cart-products -->
            <?php } else { ?>
                <p class="woffice-mini-cart-product-empty"><?php _e('No products in the cart.', 'woffice'); ?></p>
            <?php } ?>

            <?php if (sizeof(WC()->cart->get_cart()) > 0) { ?>
                <h4 class="text-center woffice-mini-cart-subtotal"><?php _e('Cart Subtotal', 'woffice'); ?>
                    : <?php echo WC()->cart->get_cart_subtotal(); ?></h4>
                <div class="text-center">
                    <a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="cart btn btn-default">
                        <i class="fa fa-shopping-cart"></i> <?php _e('Cart', 'woffice'); ?>
                    </a>
                    <a href="<?php echo esc_url(wc_get_checkout_url()); ?>" class="alt checkout btn btn-default">
                        <i class="fa fa-credit-card"></i> <?php _e('Checkout', 'woffice'); ?>
                    </a>
                </div>
            <?php };
        }
        
        /**
         * Custom Mini Cart
         *
         * @return void
         */
        static function print_mini_cart() {
            ?>
            <div id="woffice-minicart-top">
                 <div class="woffice_widget_shopping_cart_content">
                    <?php Woffice_WooCommerce::mini_cart_content();?>
                </div>
            </div>
            <?php
        }

        /**
         * Ensure cart contents update when products are added to the cart via AJAX
         *
         * @param array $fragments
         * @return array
         */
        public function woffice_woocommerce_header_add_to_cart_fragment( $fragments ) {
            ob_start();
            ?>
            <a href="javascript:void(0)" id="nav-cart-trigger" title="<?php _e( 'View your shopping cart', 'woffice' ); ?>" class="<?php echo sizeof(WC()->cart->get_cart()) > 0 ? 'active' : ''; ?> cart-content">
                <p class="stellar-mini-cart">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="23" viewBox="0 0 24 23" fill="none">
                        <path d="M23.4624 4.64725C23.0079 4.06641 22.3005 3.71283 21.5682 3.71283H6.18748L5.70758 1.84386C5.42975 0.75796 4.47 0.000244141 3.35889 0.000244141H0.78276C0.353435 0.000244141 -0.00012207 0.353815 -0.00012207 0.783126C-0.00012207 1.21245 0.353449 1.56601 0.78276 1.56601H3.35889C3.73765 1.56601 4.06605 1.81864 4.16716 2.1974L7.24835 14.4717C7.52618 15.5576 8.48593 16.3153 9.59704 16.3153H19.6741C20.7854 16.3153 21.7703 15.5576 22.0228 14.4717L23.9169 6.69291C24.0936 5.98575 23.9421 5.22822 23.4622 4.64725H23.4624ZM22.3765 6.33938L20.4823 14.1181C20.3813 14.4969 20.053 14.7495 19.674 14.7495H9.597C9.21823 14.7495 8.88984 14.4969 8.78873 14.1181L6.59152 5.30389H21.5682C21.8208 5.30389 22.0732 5.43021 22.2248 5.63227C22.3764 5.83434 22.4522 6.08697 22.3764 6.33943L22.3765 6.33938Z" fill="#2D3342"/>
                        <path d="M10.1274 17.3254C8.68775 17.3254 7.50092 18.5125 7.50092 19.9519C7.50092 21.3916 8.68793 22.5784 10.1274 22.5784C11.5671 22.5786 12.7541 21.3916 12.7541 19.9519C12.7541 18.5125 11.5671 17.3254 10.1274 17.3254ZM10.1274 20.9875C9.54658 20.9875 9.09189 20.533 9.09189 19.9519C9.09189 19.3711 9.5464 18.9164 10.1274 18.9164C10.7083 18.9164 11.1629 19.3709 11.1629 19.9519C11.1629 20.5076 10.683 20.9875 10.1274 20.9875Z" fill="#2D3342"/>
                        <path d="M18.8153 17.3254C17.3757 17.3254 16.1888 18.5125 16.1888 19.9519C16.1888 21.3916 17.3759 22.5784 18.8153 22.5784C20.255 22.5784 21.4418 21.3914 21.4418 19.9519C21.4167 18.5125 20.255 17.3254 18.8153 17.3254ZM18.8153 20.9875C18.2345 20.9875 17.7798 20.533 17.7798 19.9519C17.7798 19.3711 18.2343 18.9164 18.8153 18.9164C19.3962 18.9164 19.8509 19.3709 19.8509 19.9519C19.8509 20.5076 19.371 20.9875 18.8153 20.9875Z" fill="#2D3342"/>
                    </svg>
                </p>
                <span class="woocommerce-cart-count count"><bdi>
                    <?php echo (sizeof( WC()->cart->get_cart()) > 0) ? WC()->cart->get_cart_contents_count() : ''; ?>
                </bdi></span>
            </a>
            <?php

            $fragments['a.cart-content'] = ob_get_clean();
            ob_start();
            Woffice_WooCommerce::mini_cart_content();
            $fragments['div.woffice_widget_shopping_cart_content'] = '<div class="woffice_widget_shopping_cart_content">' . ob_get_clean() . '</div>';
            
            return $fragments;
        }

    }
}

/**
 * Let's fire it :
 */
new Woffice_WooCommerce();



