/**
 * Main Woffice object
 *
 * @since 2.5.0
 * @type {{}}
 */
 var Woffice_Backend_Admin = {

    /**
     * Initialize the Woffice's JS
     *
     * @param {jQuery} $
    */
    init: function ($) {
        "use strict";

    	var self = this;

    	self.$ = (typeof $ === 'undefined') ? jQuery : $;

        self.Settings.Settings_Option();
        self.UpdateCoreplugins.watch();
        self.Woffice_Menu_Icons.Load_Icons();

        {
            self.UpdateCoreplugins.watch();
            self.Woffice_Menu_Icons.Load_Icons();
        }
    },

    Settings: {
        Settings_Option: function(){
            var $ = Woffice_Backend_Admin.$;
            $('body').on('focusout','#fw-edit-options-modal-title',function(){
                var title = $(this).val();
                if(title !== '' || title !== undefined) {
                    var slug = title.toLowerCase().split(' ').join('_');
                    $(this).parents('#fw-backend-option-fw-edit-options-modal-title').siblings('#fw-backend-option-fw-edit-options-modal-status_slug').find('#fw-edit-options-modal-status_slug').attr("value",slug);
                }
            });
        }
    },
    UpdateCoreplugins: {
        watch: function() {
            wp.updates;
            var $ = Woffice_Backend_Admin.$;
            $( document ).on( 'wp-theme-update-success', function( e, response ) {
                if(response.slug == 'woffice') {
                     $.ajax({
                        url: WOFFICE_BACKEND.ajax_url,
                        data: {
                            action: 'update_woffice_core_plugin',
                            nonce: WOFFICE_BACKEND.nonce
                        },
                        beforeSend: function(){
                            $('.woffice-core-updatermodal').show();
                            $('.woffice-core-updater-wrap').html(WOFFICE_BACKEND.updater_content);
                        },
                        success: function (result) {
                            var output = JSON.parse(result);
                            if(output.success) {
                                $('.woffice-core-updater-wrap').html(WOFFICE_BACKEND.updater_success_message);
                            }
                        }
                    }).done(function() {
                        $('.woffice-core-updater-wrap').html('');
                        $('.woffice-core-updatermodal').hide();
                    });
                }
            });
        }
    },

    Woffice_Menu_Icons : {

        formatText: function(icon) {
            var $ = Woffice_Backend_Admin.$;
            return $('<span><i class="' + $(icon.element).data('icon') + '"></i> ' + icon.text + '</span>');
        },
        
        Load_Icons: function() {
            var $ = Woffice_Backend_Admin.$;
            var self = this;
         
            if($('.woffice_menu_item_icon').length > 0){
                var iconsource = Object.keys(JSON.parse(WOFFICE_BACKEND.iconSource));
                
                $('.woffice_menu_item_icon').each(function(){
                    var setSelectedIcon = $(this).fontIconPicker({
                        source: iconsource,
                        searchSource: iconsource,
                        iconsPerPage:30
                    });

                    var selected_icon = $(this).parents('.logged-input-holder').find('.woffice_menu_item_icon_selected').val();
                    if(selected_icon == '') {
                        selected_icon = 'fip-icon-block';
                    }
                    setSelectedIcon.setIcon(''+selected_icon+'');
                })
                
            }
        }
    }
};

/**
 * Start it!
 *
 * We give it a jQuery object to play with
 */
Woffice_Backend_Admin.init(jQuery);